<?php
/* --------------------------------------------------------------
 ConfigurationGroupRepository.php 2020-02-18
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Repositories\Implementations;

use Gambio\Core\Configuration\Models\Read\Collections\ConfigurationGroup;
use Gambio\Core\Configuration\Models\Read\ConfigurationGroupId;
use Gambio\Core\Configuration\Repositories\Components\ConfigurationMapper;
use Gambio\Core\Configuration\Repositories\Components\ConfigurationReader;
use Gambio\Core\Configuration\Repositories\ConfigurationGroupRepository as ConfigurationGroupRepositoryInterface;

/**
 * Class ConfigurationGroupRepository
 * @package Gambio\Core\Configuration\Repositories\Implementations
 */
class ConfigurationGroupRepository implements ConfigurationGroupRepositoryInterface
{
    /**
     * @var ConfigurationReader
     */
    private $reader;
    
    /**
     * @var ConfigurationMapper
     */
    private $mapper;
    
    
    /**
     * ConfigurationGroupRepository constructor.
     *
     * @param ConfigurationReader $reader
     * @param ConfigurationMapper $mapper
     */
    public function __construct(ConfigurationReader $reader, ConfigurationMapper $mapper)
    {
        $this->reader = $reader;
        $this->mapper = $mapper;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getByGroup(ConfigurationGroupId $group, array $exclude = []): ConfigurationGroup
    {
        $data = $this->reader->fetchByGroup($group, $exclude);
        
        return $this->mapper->map($data);
    }
}